<?php get_header(); ?>
	<article>
		<div class="archive_header">
			<div class="inner">
				<h1 class="title">ブログ一覧</h1>
			</div>
		</div>
		<section>
			<div class="inner">
				<div class="paragraph">
					<ol class="blog_list split_3">
						<?php while ( have_posts() ) : the_post(); ?>
							<li class="split_content">
								<a href="<?php the_permalink(); ?>">
									<p class="blog_list_image">
										<?php
											if (has_post_thumbnail()) {
												the_post_thumbnail('full');
											} else {
												echo '<img src="' . get_bloginfo('template_url') . '/images/common/common_eyecatch.jpg' . '" alt="thumbnail" />';
											}
										?>
										<span class="blog_list_guide"></span>
									</p>
								</a>
								<p class="blog_list_info">
									<span class="blog_list_date"><?php the_time('Y.m.d') ?></span>
									<span class="blog_list_category">
										<?php
											$cat = get_the_category();
											$cat = $cat[0];
											echo '<a href="' . get_category_link( $cat->term_id ) . '">' . $cat->cat_name . '</a>';
										?>
									</span>
								</p>
								<p class="blog_list_contents">
									<a href="<?php the_permalink(); ?>">
									<span class="blog_list_title"><?php the_title(); ?></span>
									</a>
								</p>
							</li>
						<?php endwhile; ?>
					</ol>
				</div>
			</div>
		</section>
		<section class="section_pagenation">
			<div class="inner">
				<div class="paragraph">
					<?php
						$prev_link = get_previous_posts_link('前へ');
						$next_link = get_next_posts_link('次へ');
						if ( isset( $prev_link ) or isset( $next_link ) ) {
							echo "<ul class=\"pagination\">", PHP_EOL;
							echo "<li class=\"btnPrev\">";
							if( isset( $prev_link ) ) {
								echo $prev_link;
							}
							echo "</li>", PHP_EOL;
							echo "<li class=\"btnTop\"><a href=\"";
							echo get_pagenum_link(1);
							echo "\">先頭に戻る</a></li>";
							echo "<li class=\"btnNext\">";
							echo $next_link;
							echo "</li>", PHP_EOL;
							echo '</ul>', PHP_EOL;
						}
					?>
				</div>
			</div>
		</section>
	</article>
<?php get_footer(); ?>
